function [time,precip] = ImportingORGRain()


cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\Optical Rain Gauge');

currdir = dir;


time = [];
precip = [];
std_precip = [];
for i = 1:length(currdir)
	
	cdfflag = strfind(currdir(i).name,'.cdf');
	
	if isempty(cdfflag)
		continue
	end
	
	
	%% Importing Time
	%year index
	yi = strfind(currdir(i).name,'.2016');
	
	start_time = datetime(currdir(i).name(yi+1:yi+8),'InputFormat','yyyyMMdd');
	offset_time = ncread(currdir(i).name,'time');
	
	vec_time = repmat(start_time,length(offset_time),1);
	vec_time = datevec(vec_time);
	
	currtime = vec_time;
	currtime(:,6) = currtime(:,6) + offset_time;
	currtime = datetime(currtime);
	
	%% Importing Rain Data
	currprecip_mean = ncread(currdir(i).name,'precip_mean');
	currprecip_sd = ncread(currdir(i).name,'precip_sd');
	
	time = [time ; currtime];
	precip = [precip ; currprecip_mean];
	std_precip = [std_precip ; currprecip_sd];
	
	
end



